/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.elf.relocation;

import ghidra.app.util.bin.format.elf.ElfHeader;
import ghidra.app.util.bin.format.elf.ElfRelocation;
import ghidra.app.util.bin.format.elf.ElfSectionHeader;
import ghidra.app.util.bin.format.elf.ElfSymbol;
import ghidra.app.util.bin.format.elf.relocation.ElfRelocationContext;
import ghidra.app.util.bin.format.elf.relocation.ElfRelocationHandler;
import ghidra.app.util.importer.MessageLog;
import ghidra.program.model.address.Address;
import ghidra.program.model.listing.Program;
import ghidra.program.model.mem.Memory;
import ghidra.program.model.mem.MemoryAccessException;
import ghidra.program.model.symbol.SymbolTable;
import ghidra.util.exception.NotFoundException;

public class eBPF_ElfRelocationHandler
extends ElfRelocationHandler {
    public boolean canRelocate(ElfHeader elf) {
        return elf.e_machine() == 247;
    }

    public void relocate(ElfRelocationContext elfRelocationContext, ElfRelocation relocation, Address relocationAddress) throws MemoryAccessException, NotFoundException {
        ElfHeader elf = elfRelocationContext.getElfHeader();
        if (elf.e_machine() != 247) {
            return;
        }
        Program program = elfRelocationContext.getProgram();
        Memory memory = program.getMemory();
        int type = relocation.getType();
        int symbolIndex = relocation.getSymbolIndex();
        boolean appliedSymbol = true;
        if (type == 1) {
            try {
                int SymbolIndex = relocation.getSymbolIndex();
                ElfSymbol Symbol2 = elfRelocationContext.getSymbol(SymbolIndex);
                String map = Symbol2.getNameAsString();
                SymbolTable table = program.getSymbolTable();
                Address mapAddr = table.getSymbols(map).next().getAddress();
                String sec_name = elfRelocationContext.relocationTable.getSectionToBeRelocated().getNameAsString();
                if (sec_name.toString().contains("debug")) {
                    return;
                }
                long value = mapAddr.getAddressableWordOffset();
                Byte dst = memory.getByte(relocationAddress.add(1L));
                memory.setLong(relocationAddress.add(4L), value);
                memory.setByte(relocationAddress.add(1L), (byte)(dst + 16));
            }
            catch (NullPointerException SymbolIndex) {}
        } else if (type == 10) {
            try {
                int SymbolIndex = relocation.getSymbolIndex();
                ElfSymbol Symbol3 = elfRelocationContext.getSymbol(SymbolIndex);
                String func_or_sec = Symbol3.getNameAsString();
                long instr_next = relocationAddress.add(8L).getAddressableWordOffset();
                if (Symbol3.isFunction()) {
                    SymbolTable table = program.getSymbolTable();
                    Address funcAddr = table.getSymbols(func_or_sec).next().getAddress();
                    String sec_name = elfRelocationContext.relocationTable.getSectionToBeRelocated().getNameAsString();
                    if (sec_name.toString().contains("debug")) {
                        return;
                    }
                    long value = funcAddr.getAddressableWordOffset();
                    int offset = (int)(value - instr_next);
                    memory.setInt(relocationAddress.add(4L), offset);
                } else if (Symbol3.isSection() && memory.getInt(relocationAddress) == 4229) {
                    ElfSectionHeader sec = elfRelocationContext.getElfHeader().getSection(func_or_sec);
                    long sec_start = program.getImageBase().getOffset() + sec.getAddress();
                    int current_imm = memory.getInt(relocationAddress.add(4L));
                    int func_sec_offset = (current_imm + 1) * 8;
                    long func_addr = sec_start + (long)func_sec_offset;
                    int offset = (int)(func_addr - instr_next);
                    memory.setInt(relocationAddress.add(4L), offset);
                }
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
        if (appliedSymbol && symbolIndex == 0) {
            eBPF_ElfRelocationHandler.markAsWarning((Program)program, (Address)relocationAddress, (String)Long.toString(type), (String)"applied relocation with symbol-index of 0", (MessageLog)elfRelocationContext.getLog());
        }
    }
}

